/*
 * Copyright (c) 2024 Oray Inc. All rights reserved.
 *
 * No Part of this file may be reproduced, stored
 * na retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Oray Inc.
 *
 * @author wuwenze
 */
package com.oray.sunlogin;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

import com.oray.sunlogin.api.SunloginAuthClient;
import com.oray.sunlogin.api.SunloginControlClient;
import com.oray.sunlogin.api.SunloginRemoteClient;
import com.oray.sunlogin.api.dto.LocateHostRequest;
import com.oray.sunlogin.api.dto.RemoteControlRequest;
import com.oray.sunlogin.api.entity.DeviceInfo;

public class TestSunloginClientApi {
    private static SunloginControlClient controlClient;
    private static SunloginRemoteClient remoteClient;

    @BeforeClass
    public static void beforeClass() {
        // 初始化授权客户端
        final SunloginAuthClient authClient = new SunloginAuthClient(
                "https://openapi.sunlogin.oray.com",
                "<yourApiKey>", // 参见：【系统设置】>【API集成】>【API KEY】
                "<yourApiSecret>" // 参见：【系统设置】>【API集成】>【API KEY】
        );
        // 连接本地的向日葵主控端
        controlClient = new SunloginControlClient("http://127.0.0.1:12138", authClient);
        // 连接本地的向日葵被控端
        remoteClient = new SunloginRemoteClient("http://127.0.0.1:21238", authClient);
    }

    @Test
    public void testControlClient_LaunchApp() {
        // 调起主控
        controlClient.launchApp();
    }

    @Test
    public void testControlClient_RemoteControl() {
        // 指定识别码发起远控
        final Boolean result = controlClient.remoteControl(
                new RemoteControlRequest("", "567167xxx", "4p3xxx"));
        Assert.assertEquals("发起远控失败", result, true);
    }

    @Test
    public void testControlClient_LocateHost() {
        // 定位到指定设备后，再发起远控
        final Boolean result = controlClient.locateHost(
                new LocateHostRequest("1625139245", "1"));
        Assert.assertEquals("定位设备并发起远控失败", result, true);
    }

    @Test
    public void testRemoteClient_GetDeviceInfo() {
        // 获取向日葵企业被控设备信息
        final DeviceInfo deviceInfo = remoteClient.getDeviceInfo();
        System.out.printf("当前被控端设备信息：%s\n", deviceInfo.toString());
    }
}