/*
 * Copyright (c) 2024 Oray Inc. All rights reserved.
 *
 * No Part of this file may be reproduced, stored
 * na retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Oray Inc.
 *
 * @author wuwenze
 */
package com.oray.sunlogin;

import com.oray.sunlogin.api.SunloginApiCipher;
import org.junit.Assert;
import org.junit.Test;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class TestSunloginApiCipher {

    @Test
    public void test() throws NoSuchPaddingException, IllegalBlockSizeException,
            NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {

        final SunloginApiCipher cipher = new SunloginApiCipher("vflzqa8qy3fy091np1h2fewktj1yyx58");

        final String plaintext = "向日葵，国民远控，守护国民安全";
        final String expect = "YH+PAtr8YmQ+O0c5UHKAMWIS/fcIZIesNHTgDYLr07HE9FBwBPZq5aGJp/Me3ab4";

        final String encrypted = cipher.encrypt(plaintext);
        System.out.printf("encrypt = %s\n", encrypted);
        Assert.assertEquals(encrypted, expect);

        final String decrypted = cipher.decrypt(encrypted);
        System.out.printf("decrypted = %s\n", decrypted);
        Assert.assertEquals(decrypted, plaintext);
    }
}