/*
 * Copyright (c) 2024 Oray Inc. All rights reserved.
 *
 * No Part of this file may be reproduced, stored
 * na retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Oray Inc.
 *
 * @author wuwenze
 */
package com.oray.sunlogin.api.factory;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;

public class ObjectMapperFactory {
    public static ObjectMapper getInstance() {
        return ObjectMapperSingleton.INSTANCE.getObjectMapper();
    }

    enum ObjectMapperSingleton {
        INSTANCE;

        private final ObjectMapper objectMapper;
        ObjectMapperSingleton() {
            final JsonFactory jsonFactory = new JsonFactory();
            jsonFactory.enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION.mappedFeature());

            this.objectMapper = new ObjectMapper(jsonFactory);
            this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        }
        public ObjectMapper getObjectMapper() {
            return this.objectMapper;
        }
    }
}