/*
 * Copyright (c) 2024 Oray Inc. All rights reserved.
 *
 * No Part of this file may be reproduced, stored
 * na retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Oray Inc.
 *
 * @author wuwenze
 */
package com.oray.sunlogin.api.dto;

import java.util.LinkedHashMap;
import java.util.Map;

public record RemoteControlRequest(String remoteId, String fastcode, String verifyCode) {

    public Map<String, String> asMap() {
        // 使用 LinkedHashMap 保持参数顺序
        final Map<String, String> result = new LinkedHashMap<>();
        result.put("remoteid", remoteId);
        result.put("fastcode", fastcode);
        result.put("verifycode", verifyCode);
        return result;
    }
}