/*
 * Copyright (c) 2024 Oray Inc. All rights reserved.
 *
 * No Part of this file may be reproduced, stored
 * na retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Oray Inc.
 *
 * @author wuwenze
 */
package com.oray.sunlogin.api.algorithm;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Md5 {

    public static String digest(String input) {
        try {
            final MessageDigest md = MessageDigest.getInstance("MD5");
            final byte[] digest = md.digest(input.getBytes());

            final StringBuilder result = new StringBuilder();
            for (byte b : digest) {
                String hex = Integer.toHexString(0xff & b);
                if (hex.length() == 1) result.append('0');
                result.append(hex);
            }
            return result.toString();

        } catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algo: MD5", e);
        }
    }
}