/*
 * Copyright (c) 2024 Oray Inc. All rights reserved.
 *
 * No Part of this file may be reproduced, stored
 * na retrieval system, or transmitted, in any form, or by any means,
 * electronic, mechanical, photocopying, recording, or otherwise,
 * without the prior consent of Oray Inc.
 *
 * @author wuwenze
 */
package com.oray.sunlogin.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oray.sunlogin.api.entity.DeviceInfo;
import com.oray.sunlogin.api.factory.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 向日葵被控端API
 */
public class SunloginRemoteClient extends SunloginClientApi {
    private static final Logger logger = LoggerFactory.getLogger(SunloginRemoteClient.class);

    public SunloginRemoteClient(String host, SunloginAuthClient authClient) {
        super(host, authClient);
    }


    /**
     * 获取当前设备信息
     * @see https://sunlogin.apifox.cn/api-150555740
     */
    public DeviceInfo getDeviceInfo() {
        final SunloginClientApiResult result = super.sendRequest("GET", "/get_deviceinfo", null, null);
        if (result.getCode() != 200) {
            logger.error("get device info fail[status={}, code={}, message={}]",
                    result.getHttpStatus(), result.getCode(), result.getMessage());
        }
        // 解析设备信息
        try {
            return ObjectMapperFactory.getInstance()
                    .readValue(result.getDecryptedData(), DeviceInfo.class);
        } catch (JsonProcessingException e) {
            throw new IllegalStateException("unmarshal response data fail", e);
        }
    }
}